<?php

namespace App\Http\Controllers\Admin;
use Illuminate\View\View;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Car;
use App\Models\Booking;

class AdminController extends Controller
{
    //
    public function login()
    {
        return view('admin.login');
    }

    public function dashboard(Request $request): View
    {
        $agencies = User::where('role', 'AGENCY')->count();
        $customers = User::where('role', 'USER')->count();
        $cars = Car::count();
        $bookings = Booking::count();
        $data = array(
            'agencies' => $agencies,
            'customers' => $customers,
            'cars' => $cars,
            'bookings' => $bookings,
            'page' => 'dashboard'
        );
        return view('admin.dashboard', $data);
    }

    public function agency(Request $request): View
    {
        $agencies_count = User::where('role', 'AGENCY')->count();
        $agencies = User::where('role', 'AGENCY')->get();
        $data = array(
            'agencies' => $agencies,
            'agencies_count' => $agencies_count,
            'page' => 'agency'
        );
        return view('admin.agency', $data);
    }

    public function customer(Request $request): View
    {
        $customers_count = User::where('role', 'USER')->count();
        $customers = User::where('role', 'USER')->get();
        $data = array(
            'customers' => $customers,
            'customers_count' => $customers_count,
            'page' => 'customer'
        );
        return view('admin.customer', $data);
    }

    public function booking(Request $request): View
    {
        $bookings_count = Booking::count();
        $bookings = Booking::get();
        $data = array(
            'bookings' => $bookings,
            'bookings_count' => $bookings_count,
            'page' => 'booking'
        );
        return view('admin.booking', $data);
    }

    public function car(Request $request): View
    {
        $cars_count = Car::count();
        $cars = Car::with('category')->with('agency')->get();
        $data = array(
            'cars_count' => $cars_count,
            'cars' => $cars,
            'page' => 'car'
        );
        //dd($data);
        return view('admin.car', $data);
    }
}
