<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Models\User;
use App\Models\Notification;
use Exception;

class AgencyController extends Controller
{
    public function register(Request $request){
        try {
            $validator = Validator::make(
                $request->all(),
                [
                    'name' => 'required',
                    'email' => 'required',
                    'password' => 'required',
                    'country_id' => 'required',
                    'country' => 'required'
                ]
            );
            if ($validator->fails()) {
                return response()->json(['status' => false, 'errors' => $validator->errors()]);
            }
            $user = new User();
            $user->name = $request->name;
            $user->email = $request->email;
            $user->country_id = $request->country_id;
            $user->country = $request->country;
            $user->role = 'AGENCY';
            $user->password = Hash::make($request->password);
            $user->device_token = $request->device_token??'';
            $user->save();
            if($user == true){
                $response = ['status' => true, 'data' => $user, 'message' => "Created successfully."];
                return response($response, 200);
            }else{
                $response = ['status' => false, 'data' => null, 'message' => "Something went wrong. Please try again later. Thank you!"];
                return response($response, 400);
            }
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }
    //
    public function login(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'email' => 'required',
                'password' => 'required'
            ]);
            if ($validator->fails()) {
                return response()->json(['status' => false, 'errors' => $validator->errors()]);
            }
            $credentials = $request->only('email', 'password');
            
            if (!auth()->attempt($credentials)) {
                $response = ['status' => false, 'message' => "Invalid Credentials"];
                return response($response, 400);
            } else {
                $user_id = auth()->user()->id;
                $data = User::where('id', $user_id)->first();

                if ($data->role != 'AGENCY') {
                    $response = ['status' => false, 'data' => $data, 'message' => "Invalid credentials!"];
                    return response($response, 400);
                } else {
                    $data->device_token = $request->device_token?$request->device_token:"";
                    $data->save();
                    $data->token = auth()->user()->createToken('API Token')->accessToken;
                    $response = ['status' => true, 'data' => $data, 'message' => "Account login successfully!"];
                    return response($response, 200);
                }
            }
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }

    public function forgot(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'email' => 'required'
            ]);
            if ($validator->fails()) {
                return response()->json(['status' => false, 'errors' => $validator->errors()]);
            }
            $user = User::where('email', $request->email)->first();
            if($user){
                $response = ['status' => true, 'data' => $user, 'message' => "OTP Sent to the email"];
                return response($response, 200);
            }else{  
                $response = ['status' => false, 'message' => "Invalid Request"];
                return response($response, 400);
            }
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }

    public function verification(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'email' => 'required',
                'otp' => 'required'
            ]);
            if ($validator->fails()) {
                return response()->json(['status' => false, 'errors' => $validator->errors()]);
            }
            $user = User::where('email', $request->email)->first();
            if($user){
                if($user->otp == $request->otp){
                    $response = ['status' => true, 'data' => $user, 'message' => "Success"];
                    return response($response, 200);
                }else{
                    $response = ['status' => true, 'data' => $user, 'message' => "Invalid OTP"];
                    return response($response, 200);
                }
            }else{  
                $response = ['status' => false, 'message' => "Invalid Request"];
                return response($response, 400);
            }
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }

    public function reset_password(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'id' => 'required',
                'password' => 'required'
            ]);
            if ($validator->fails()) {
                return response()->json(['status' => false, 'errors' => $validator->errors()]);
            }
            $user = User::where('id', $request->id)->first();
            if($user){
                $user->password = Hash::make($request->password);
                if($user->save()){
                    $response = ['status' => true, 'data' => $user, 'message' => "Success"];
                    return response($response, 200);
                }else{
                    $response = ['status' => false, 'message' => "Something went wrong"];
                    return response($response, 400);
                }
            }else{  
                $response = ['status' => false, 'message' => "Invalid Request"];
                return response($response, 400);
            }
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }

    public function getAllNotifications(Request $request)
    {
        try {
            $user_id = Auth::user()->id;
            $notifications = Notification::where('user_id', $user_id)->get();
            $response = ['status' => true, 'data' => $notifications, 'message' => "Success!"];
            return response($response, 200);
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }
}
