<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Exception;
use App\Models\Category;
use App\Models\City;
use App\Models\Country;

class ApiController extends Controller
{
    //
    public function getAllCategories(Request $request)
    {
        try {
            $categories = Category::orderBy('name')->get();
            $response = ['status' => true, 'data' => $categories, 'message' => "Success!"];
            return response($response, 200);
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }

    public function getAllCities(Request $request)
    {
        try {
            $cities = City::orderBy('name')->get();
            $response = ['status' => true, 'data' => $cities, 'message' => "Success!"];
            return response($response, 200);
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }

    public function getAllCountries(Request $request)
    {
        try {
            $countries = Country::orderBy('name')->get();
            $response = ['status' => true, 'data' => $countries, 'message' => "Success!"];
            return response($response, 200);
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }
}
