<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Exception;

class UserController extends Controller
{
    //
    public function register(Request $request){
        try {
            $validator = Validator::make(
                $request->all(),
                [
                    'name' => 'required',
                    'phone' => 'required',
                    'password' => 'required'
                ]
            );
            if ($validator->fails()) {
                return response()->json(['status' => false, 'errors' => $validator->errors()]);
            }
            $user = new User();
            $user->name = $request->name;
            $user->phone = $request->phone;
            $user->role = 'USER';
            $user->password = Hash::make($request->password);
            $user->device_token = $request->device_token??'';
            $user->save();
            if($user == true){
                $response = ['status' => true, 'data' => $user, 'message' => "Created successfully."];
                return response($response, 200);
            }else{
                $response = ['status' => false, 'data' => null, 'message' => "Something went wrong. Please try again later. Thank you!"];
                return response($response, 400);
            }
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }

    public function login(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'phone' => 'required',
                'password' => 'required'
            ]);
            if ($validator->fails()) {
                return response()->json(['status' => false, 'errors' => $validator->errors()]);
            }
            $credentials = $request->only('phone', 'password');
            
            if (!auth()->attempt($credentials)) {
                $response = ['status' => false, 'message' => "Invalid Credentials"];
                return response($response, 400);
            } else {
                $user_id = auth()->user()->id;
                $data = User::where('id', $user_id)->first();

                if ($data->role != 'USER') {
                    $response = ['status' => false, 'data' => $data, 'message' => "Invalid credentials!"];
                    return response($response, 400);
                } else {
                    $data->device_token = $request->device_token?$request->device_token:"";
                    $data->save();
                    $data->token = auth()->user()->createToken('API Token')->accessToken;
                    $response = ['status' => true, 'data' => $data, 'message' => "Account login successfully!"];
                    return response($response, 200);
                }
            }
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }

    public function update(Request $request)
    {
        try {
            $user_id = Auth::user()->id;
            $user = User::where('id', $user_id)->first();
            if($user){
                if(isset($request->name) && $request->name != ''){
                    $user->name = $request->name;
                }
                if(isset($request->phone) && $request->phone != ''){
                    $user->phone = $request->phone;
                }
                if(isset($request->email) && $request->email != ''){
                    $user->email = $request->email;
                }
                if($user->save()){
                    $response = ['status' => true, 'data' => $user, 'message' => "Updated successfully!"];
                    return response($response, 200);
                }else{
                    $response = ['status' => false, 'data' => '', 'message' => "Something went wrong!"];
                    return response($response, 400);
                }
            }else{
                //invalid 
                $response = ['status' => false, 'data' => '', 'message' => "Invalid Request!"];
                return response($response, 400);
            }
        } catch (Exception $e) {
            $response = ['status' => false, 'data' => null, 'message' => $e->getMessage()];
            return response($response, 400);
        }
    }
}
