@extends('layouts.app-admin')
@section('content')
<!--begin::Content-->
<div class="content d-flex flex-column flex-column-fluid" id="kt_content">
	<!--begin::Toolbar-->
	<div class="toolbar" id="kt_toolbar">
		<!--begin::Container-->
		<div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
			<!--begin::Page title-->
			<div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
				<!--begin::Title-->
				<h1 class="d-flex text-dark fw-bolder fs-3 align-items-center my-1">User Details</h1>
				<!--end::Title-->
				<!--begin::Separator-->
				<span class="h-20px border-gray-300 border-start mx-4"></span>
				<!--end::Separator-->
			</div>
			<!--end::Page title-->
		</div>
		<!--end::Container-->
	</div>
	<!--end::Toolbar-->
	<!--begin::Post-->
	<div class="post d-flex flex-column-fluid" id="kt_post">
		<!--begin::Container-->
		<div id="kt_content_container" class="container-xxl">
			<!--begin::Order details page-->
			<div class="d-flex flex-column gap-7 gap-lg-10">
				<!--begin::Order summary-->
				<div class="d-flex flex-column flex-xl-row gap-7 gap-lg-10">
					<!--begin::Order details-->
					<div class="card card-flush py-4 flex-row-fluid">
						<!--begin::Card header-->
						<div class="card-header">
							<div class="card-title">
								<h2>User</h2>
							</div>
						</div>
						<!--end::Card header-->
						<!--begin::Card body-->
						<div class="card-body pt-0">
							<div class="table-responsive">
								<!--begin::Table-->
								<table class="table align-middle table-row-bordered mb-0 fs-6 gy-5 min-w-300px">
									<!--begin::Table body-->
									<tbody class="fw-bold text-gray-600">
										<tr>
											<td class="text-muted">
												<div class="d-flex align-items-center">Name</div>
											</td>
											<td class="fw-bolder text-end"><?=ucfirst($user->name);?></td>
										</tr>
										<tr>
											<td class="text-muted">
												<div class="d-flex align-items-center">Email</div>
											</td>
											<td class="fw-bolder text-end"><?=$user->email??'-';?></td>
										</tr>
									</tbody>
									<!--end::Table body-->
								</table>
								<!--end::Table-->
							</div>
						</div>
						<!--end::Card body-->
					</div>
					<!--end::Order details-->
				</div>
				<!--end::Order summary-->
				<div class="d-flex flex-column flex-xl-row gap-7">
					<!--begin::Card-->
					<div class="card card-flush py-4 flex-row-fluid">
						<!--begin::Card header-->
						<div class="card-header border-0 pt-6">
						<div class="card-title">
								<h2>Properties</h2>
							</div>
						</div>
						<!--end::Card header-->
						<!--begin::Card body-->
						<div class="card-body pt-0">
							<!--begin::Table-->
							<table class="table align-middle table-row-dashed fs-6 gy-5" id="kt_customers_table">
								<!--begin::Table head-->
								<thead>
									<!--begin::Table row-->
									<tr class="text-start text-gray-400 fw-bolder fs-7 text-uppercase gs-0">
										<th class="min-w-125px">Title</th>
										<th class="min-w-125px">Price</th>
										<th class="min-w-125px">Created Date</th>
										<th class="min-w-125px">Status</th>
										<th class="text-end min-w-70px">Actions</th>
									</tr>
									<!--end::Table row-->
								</thead>
								<!--end::Table head-->
								<!--begin::Table body-->
								<tbody class="fw-bold text-gray-600">
									<?php foreach($properties as $property):?>
										<tr>
											<!--begin::Name=-->
											<td>
												<a href="javascript:void(0);" class="text-gray-800 text-hover-primary mb-1">
													<?=$property->title;?>
												</a>
											</td>
											<!--end::Name=-->
											<!--begin::Email=-->
											<td>
												<a href="#" class="text-gray-600 text-hover-primary mb-1"><?=$property->price;?></a>
											</td>
											<!--end::Email=-->
											<!--begin::Date=-->
											<td><?=$property->created_at;?></td>
											<td>
												<?php echo $property->status == '1' ? '<div class="badge badge-light-success fw-bolder">Active</div>' : ($property->status == '2' ? '<div class="badge badge-light-warning fw-bolder">In Review</div>' : '<div class="badge badge-light-danger fw-bolder">Blocked</div>');?>
											</td>
											<!--end::Date=-->
											<!--begin::Action=-->
											<td class="text-end">
												<a href="#" class="btn btn-sm btn-light btn-active-light-primary" data-kt-menu-trigger="click" data-kt-menu-placement="bottom-end">Actions
												<!--begin::Svg Icon | path: icons/duotune/arrows/arr072.svg-->
												<span class="svg-icon svg-icon-5 m-0">
													<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
														<path d="M11.4343 12.7344L7.25 8.55005C6.83579 8.13583 6.16421 8.13584 5.75 8.55005C5.33579 8.96426 5.33579 9.63583 5.75 10.05L11.2929 15.5929C11.6834 15.9835 12.3166 15.9835 12.7071 15.5929L18.25 10.05C18.6642 9.63584 18.6642 8.96426 18.25 8.55005C17.8358 8.13584 17.1642 8.13584 16.75 8.55005L12.5657 12.7344C12.2533 13.0468 11.7467 13.0468 11.4343 12.7344Z" fill="currentColor" />
													</svg>
												</span>
												<!--end::Svg Icon--></a>
												<!--begin::Menu-->
												<div class="menu menu-sub menu-sub-dropdown menu-column menu-rounded menu-gray-600 menu-state-bg-light-primary fw-bold fs-7 w-125px py-4" data-kt-menu="true">
													<!--begin::Menu item-->
													<div class="menu-item px-3">
														<a href="{{route('admin.propertyDetail', ['id' => $property->id])}}" class="menu-link px-3">View</a>
													</div>
													<!--end::Menu item-->
												</div>
												<!--end::Menu-->
											</td>
											<!--end::Action=-->
										</tr>
									<?php endforeach;?>
								</tbody>
								<!--end::Table body-->
							</table>
							<!--end::Table-->
						</div>
						<!--end::Card body-->
					</div>
					<!--end::Card-->
				</div>
			</div>
			<!--end::Order details page-->
		</div>
		<!--end::Container-->
	</div>
	<!--end::Post-->
</div>
<!--end::Content-->
@endsection